S - Dell Sales team spends enormous time on placing orders from existing customers than generating new leads and converting them. Sales leaders brought this problem to me to figure out how to serve existing customers better. In my discussions, I realized there are 2 main problems to solve here. 1) Dell customers aren’t aware they’re making repeat purchase of product configurations because 1 customer has several buyers and Dell products are highly configurable. 2) Existing customers need to change their behavior to start ordering online. For sales reps, it’s not easy to figure out if customer is ordering same config unless sales rep compares the product configuration manually with past orders in 3 different places. For commercial customers, 30% revenue comes through this mode.

T - I could see that if we figure this out, then the existing customers can move to self-serve purchases and free up sales time for lead generation activities.

A -

- First, worked with data science team to analyze repeat purchases, potential $10B revenue could be automated online if I can start showing customers past ordered product configs upfront. Potentially, $10M+ worth of sales costs can be repurposed to their core job which is selling.

- How did you analyze? Look at order history and configurations, then analyze orders 6 month forward and 6 month backward.

- Work with data scientist to draw insights. What were they working on currently? Sales reporting enhancements. Requested them to pause the efforts to focus here.

- Repeat buy model:

- Create unique product configs using top 8 commodity SKUs - Processor, memory, graphics, storage, wireless, base chassis, battery, display

- Sales rep builds the quote with configured product, then repeat buy API makes the check.

- Logic to identify repeat buy - Minimum of 2 orders in the past 6 months for the same account ID

- To solve for customer education, I worked with both sales UX team and online product team to identify optimal place to show the alert of favorite product in respective user’s journey.

- I collaborated with sales apps, engineering and data science team to work on POC first to test how successful this may be. POC was based on alerting sales users on popular product configurations based on historical purchases. I worked with 3 teams PMs to build manual mapping on repeat customer behavior (Manual mapping is on identifying repeat customer purchase manually in a table + whether customer has purchased online in the past + putting a temporary flag in our APIs to trigger a sales notification that can recommend sales rep to use standard config)

Phased approach:

Repeat buy criteria:

Historical order data with a configuration, and analyze for similar configuration purchased by same customer (3 or more order – offline only)

Phase 1: Alerts based on popular ordercodes, 5% sales users engaged and acted. Needed to improve alerts.

Phase 2: Alerts based on personalized purchase history and context. 40% sales users engaged and acted.

- Based on the POC, I found that 30% of customers are successfully able to place online orders in next 30 days. I used this to proceed further to build the capability across apps to scale globally.

- Sub-story on conflict: I had to resolve with conflicting feature request - to improve quote search capabilities to support sales group worth $10B revenue with added search filters to optimize sales operational costs. Their system was migrating to Dell’s northstar sales system, but negotiated with sales team on competing priorities.

Also shared with them on benefit to their customers.

- I checked about migration plans. The migration was planned in waves. Sales mentioned that the migration cannot be delayed. I requested to consider migration of this capability in the last wave of launch because all high revenue countries were going in last wave.

- I calculated benefits for this sales group from the capability I was prioritizing. $2B revenue overlap with EMEA customers. It helped ease out on their resistance.

- I also shared next steps and future roadmap with priorities to gain their trust.

- Recent change in approach - learn from failure:

Someone on the call asked how many additional alerts will appear with the new logic

The answer is "9x more but 6x fewer" - confusing, right?

Last week we had 20k repeat buy alerts across 8,472 accounts.

The new logic generates prediction alerts for 179k system matches across 1,406 accounts.

Under the old logic, the 8,472 accounts would only see an alert if they also selected the specific config that was repeatedly purchased-- about 4% of the time. Under the new logic, the 6x fewer (1,406) accounts will be very likely to see an alert (anywhere from 50%-100%).

The new logic is VERY targeted to the accounts predicted to have successful standard configs. It is 80% accurate, versus the repeat buy alert being 11% accurate at predicting the standard config created will sell 3 or more times.

R - In 6+ months of launch, I saw about 30% of customers moved to using favorite product config leading to $300M revenue with projected $1B+ revenue to be moved online. and I also identified additional insights that can help sales teams.

How would you do this better?

1. Think about sales incentive structure sooner and act on it. For example, sales was worried about how moving customers to self-serve may affect their compensations.

2. Might skip POC 1 and move to POC 2 directly.

Resolving Conflict

This story should illustrate a situation where you mediated a disagreement or a conflict of priorities among team members or stakeholders to achieve a positive outcome.

- Situation: I was leading the development of a repeat purchase model and automated alerts to streamline a multi-billion-dollar business function. The project required close collaboration between the data science team, the engineering team, and the sales team. The conflict arose from the sales team's resistance to shifting repeat purchases to a self-serve model, as they feared it would cannibalize their relationships and commissions, while the other teams saw it as a massive efficiency gain.

- Task: My task was to resolve this fundamental conflict of priorities and build a solution that satisfied both the business need for operational efficiency and the sales team's need to maintain a positive relationship with their clients.

- Action: I started by bringing all parties to the table to understand their core motivations and concerns. I didn't frame it as a technology vs. sales issue. Instead, I worked with the data science team to create a model that would not only automate the self-serve motion but also provide the sales team with automated, AI-driven alerts for specific, high-value clients and strategic opportunities. This reframed the product from a threat to an enablement tool that would give them back time and focus on higher-value work.

- Result: By resolving the conflict and building a solution that served both parties, we successfully enabled over $6B in repeat purchases to shift to a self-serve motion, which in turn saved an estimated $10M+ in operational costs per year. The sales team adopted the new tool with enthusiasm, and we established a collaborative framework for future projects.

.